/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

public class MultiChannelBuffer {
    private float[][] channels;
    private int bufferSize;

    public MultiChannelBuffer(int n, int n2) {
        this.channels = new float[n2][n];
        this.bufferSize = n;
    }

    public void set(MultiChannelBuffer multiChannelBuffer) {
        this.bufferSize = multiChannelBuffer.bufferSize;
        this.channels = (float[][])multiChannelBuffer.channels.clone();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getChannelCount() {
        return this.channels.length;
    }

    public float getSample(int n, int n2) {
        return this.channels[n][n2];
    }

    public float getSample(int n, float f) {
        int n2 = (int)f;
        int n3 = n2 + 1;
        if (n3 == this.bufferSize) {
            return this.channels[n][n2];
        }
        float f2 = f - (float)n2;
        return this.channels[n][n2] + f2 * (this.channels[n][n3] - this.channels[n][n2]);
    }

    public void setSample(int n, int n2, float f) {
        this.channels[n][n2] = f;
    }

    public float[] getChannel(int n) {
        return this.channels[n];
    }

    public void setChannel(int n, float[] fArray) {
        System.arraycopy(fArray, 0, this.channels[n], 0, this.bufferSize);
    }

    public void setChannelCount(int n) {
        if (this.channels.length != n) {
            this.channels = new float[n][this.bufferSize];
        }
    }

    public void setBufferSize(int n) {
        if (this.bufferSize != n) {
            this.bufferSize = n;
            for (int i = 0; i < this.channels.length; ++i) {
                this.channels[i] = new float[n];
            }
        }
    }
}

